﻿/*
 
C#-Programm: WunschCalc (c)2014 by www.gossmann.at
C#-Übung: T1I3
V0.9a - last mod: 061114

Aufgabenstellung:
-----------------

T1S3 – Berechnung arithmetischer Ausdruck
Berechnen Sie einen arithmetischen Ausdruck. Die Eingabe über Konsole ist in folgender Reihenfolge
1. Eingabe erster Operand
2. Eingabe zweiter Operand
3. Eingabe Operator
Geben Sie das Ergebnis des arithmetischen Ausdrucks auf der Konsole aus. Verwenden Sie eine
switch Anweisung für die Behandlung des Operators.

Fleißaufgabe:

Abfangmaßnahmen bei Schrotteingabe, Neustartabfrage, Meldung über undefinierte Operatoren (möglich sind Potenz, Addition, Subtraktion, Multiplikation und Division ABER nicht durch 0 -> Abfangmaßnahme durch Operandentest vorher ohne try-catch-Konstrukt)

*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WunschCalc
{
    class Program
    {
        static void Main(string[] args)
        {

        // Operations-, Operanden und Ergebnisvariablen definieren

        char   CH_wish_JN     ; // dient zur abschließenden J/N-Abfrage für Neustart des Programms        
        char   CH_operation   ;

        // Initialisierungsteil:
        // ---------------------

        // guter Programmierstil heißt immer initialisieren, schlechter Programmierstil: sich in Debug-Sessions verlieren...        

        double dbl_op1     = 0;
        double dbl_op2     = 0;
        double dbl_result  = 0;

        LB_restart_prg:  // es gibt Dinge, die gehen einfach nur mit goto (auch, wenn verpönt) -> die Neustartsabfrage unten

        Console.Clear(); // Platz da am Konsolen-Schirm -> Wisch- und Weg machen...

        // dem User kurze Infos zum Programm und einen Erklärungsteil präsentieren:

        Console.WriteLine ("WunschCalc V0.9a - (c) by www.gossmann.at, nov-2014:"                                                                  );
        Console.WriteLine                                                                                                                       (""); // Übersichtsleerzeile einstreuen...
        Console.WriteLine ("WunschCalc berechnet aus nachfolgend eingegebenen Zahlen ein Ergebnis mit einer ebenfalls eingegebenen Wunschoperation");
        Console.WriteLine                                                                                                                       (""); // Übersichtsleerzeile einstreuen...

        // Eingabeteil: Operanden und gewünschte Operation holen            
        // natürlich ließe sich auch jede einzelne Operation in einem eigenen try-catch-Block einfassen, wenn User Schrott eingibt, wäre hier aber zu unübersichtlich...
        // daher alle 3 zusammen - heißt aber auch 1x was falsch eingeben wird mit Neustart des gesamten Programms bestraft... ;)

        try
          {
          Console.WriteLine ("Bitte Operand #1 eingeben:"  );
          Console.WriteLine                             (""); // Übersichtsleerzeile einstreuen...
          dbl_op1 = Convert.ToDouble (Console.ReadLine()   );

          Console.WriteLine ("Bitte Operand #2 eingeben:"  );
          Console.WriteLine                             (""); // Übersichtsleerzeile einstreuen...
          dbl_op2 = Convert.ToDouble (Console.ReadLine()   );

          Console.WriteLine ("Bitte Operation eingeben:"   );
          Console.WriteLine                             (""); // Übersichtsleerzeile einstreuen...
          CH_operation = Convert.ToChar (Console.ReadLine());
          }
        catch
            {
            Console.WriteLine                                                                                                         (""); // Übersichtsleerzeile einstreuen...
            Console.WriteLine ("Leider haben Sie einen ungültigen Wert eingegeben - bitte auf Kommapunkt, bzw. Leerzeichen, etc. achten!");
            goto LB_restart_select                                                                                                        ; // mittels zwar verpöntem, aber leider an der Stelle notwendigem goto Neustartabfrage durchführen
            }

        // Verarbeitungsteil:
        // ------------------

        // je nach gewünschter Operation

        switch (CH_operation)
               {
               case '^':
 
                    dbl_result = Math.Pow(dbl_op1, dbl_op2); // entsprechend durchführen - Ergebnis merken
                    break;

               case '+':

                    dbl_result = dbl_op1 + dbl_op2; // entsprechend durchführen - Ergebnis merken
                    break;

                case '-':

                    dbl_result = dbl_op1 - dbl_op2; // entsprechend durchführen - Ergebnis merken
                    break;

                // Sonderfall: Multiplikation
                // da gehören auch die landläufigen Mal-Xe für Anti-EDVler sowohl in Groß- u. Kleinschreibung berücksichtigt und nicht nur der Mal-* für EDVler

                case 'x':
                case 'X':
                case '*':

                     dbl_result = dbl_op1 * dbl_op2; // entsprechend durchführen - Ergebnis merken
                     break;

                // Sonderfall: Divsion:
                // Abfangmaßnahmen einleiten, wenn User verrückt ist und durch 0 dividieren lassen will...
                // ginge auch mit try-catch-Konstrukt - lohnt sich hier aber nicht...

                case '/':

                     // ist der User verrückt und wollte durch 0 dividieren lassen?
                     if (dbl_op2 == 0)
                        {
                        Console.WriteLine("Division durch 0 entdeckt - leider undefiniert und nicht durchführbar..."); // ja, dann ist es gut, dass das Programm wenigstens nicht verrückt ist -> Meldung machen, dass der User verrückt war (es ihm aber freundlich ausdrücken!)
                        goto LB_restart_select                                                                       ; // nachfragen, ob weitergemacht werden soll
                        }

                    // ansonsten geht´s eh aut. ohne else weiter mit der Divisionsoperation

                    dbl_result = dbl_op1 / dbl_op2; // entsprechend durchführen - Ergebnis merken
                    break;

                default:

                    // "fiel" Case-Anweisung bis hierher aktionslos durch, dann lag auch im Programm kein implementierter Operator vor
                    // freundliche Meldung an User geben und irgendwann mal Programm erweitern, wenn mehr Zeit...

                    Console.WriteLine ("Tut mir leid, Ihre Operation habe ich nicht implementiert und kann sie daher leider nicht durchführen...");
                    Console.WriteLine ("Hey,... - vielleicht gibt´s ja schon ein Update, welches sie kann - bitte besuchen Sie zu diesem Zweck:" );
                    Console.WriteLine                                                                                                         (""); // Übersichtsleerzeile einstreuen...
                    Console.WriteLine ("\"http://www.gossmann.at\" - Vielen Dank!"                                                               );

                    goto LB_restart_select; // nachfragen, ob weitergemacht werden soll
               
               } // END switch
            
        // Ausgabeteil:
        // ------------
            
        Console.WriteLine ("Danke, das Ergebnis Ihrer gewünschten Operation lautet: " + dbl_result);

        // Programmneustartsabfrage (es gibt Dinge, die gehen eben nur mit goto...)
        LB_restart_select:

        Console.WriteLine                                  (""); // Übersichtsleerzeile einstreuen...
        Console.WriteLine        ("noch eine Berechnung (j/n)");

        CH_wish_JN = Convert.ToChar (Console.ReadKey().KeyChar); // Taste holen lassen
        CH_wish_JN = char.ToLower                  (CH_wish_JN); // nur Kleinschreibung testen, damit nicht auch Großbuchstaben getestet werden müssen im Switch

        switch (CH_wish_JN)
               {
               case 'j': goto LB_restart_prg   ; // Neustart
               case 'n': return                ; // Feierabend
               default : goto LB_restart_select; // ungültige Taste gedrückt (kein j/n)
               }

        }
    }
}
