﻿/*

C#-Programm: Gebrauchte Boote Verkauf (c)2015 by www.gossmann.at
C#-Übung: T3TA2
V0.9 - last mod: 27052015
 
Aufgabenstellung (Zweck: Event-Handler, Buttons, Objekte und Treeviews sowie Grafiken einbinden lernen):
--------------------------------------------------------------------------------------------------------

Angabe (c) DI Walter Taus FH Burgenland


T3TA2 – Gebrauchte Booteverkauf
Implementieren Sie ein Window mit einer TreeView und der Möglichkeit Boottypen auszuwählen.
Nach Auswahl eines Boottyps erscheint ein modaler Dialog mit der Anzeige aller zum Verkauf
stehenden Boote dieses Typs in einem DataGrid.
Durch Auswahl eines Bootes im DataGrid und Drücken des Anzeigen Button kann ein modaler Dialog
mit den vollständigen Details des Bootes geöffnet werden.
Copyright Walter Taus Programmieren C# Teil 3 12
Für die Implementierung der Boote verwenden Sie eine entsprechende Klassenhierarchie. Jeder
Boottyp hat die Instanzvariablen
 Modell
 Plätze
 Preis
 Bilddatei
Bei Segelboot kommt noch die Segelfläche dazu und beim Motorboot die Motorleistung. Diese
Informationen werden dann im oben gezeigten Dialog im Feld Zusatzinfo angezeigt.
-----------------------------------------------------------------------
 
 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

 QUELLENNACHWEIS UND HINWEIS ZU DEN VERWENDETEN BILDERN: SÄMTLICHE BILDER DIENEN NICHT KOMMERZIELLEN ZWECKEN UND WURDEN DEM INTERNET UNTER FOLGENDEN URLS ENTNOMMEN:

 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 
 Ruderboote:
 -----------
 
 http://jpphila.rakusaba.jp/reiseheim/perupix/einbaum.jpg
 Einbaum

 http://www.baseloutdoor.ch/_pics/626/_760x263_0_5397141226989279_0_6x218_ffffff/24er_beim_SCZ.jpg
 Sportboot

 http://www.mama-livic.com/pictures/Fischerboot_250px.jpg
 Touristenboot
 
 https://www.mach-mal.de/uploads/51e96c1b-97e8-4d50-8f43-5b1ad9739e06_detail.jpg
 Flaschenfloss
 
 Segelboote:
 -----------
 
 http://www.op-marburg.de/var/storage/images/op/lokales/marburg/eine-segeljolle-verzeiht-keine-fehler/50966431-1-ger-DE/Eine-Segeljolle-verzeiht-keine-Fehler_ArtikelQuer.jpg
 Segeljolle

 http://femokratie.com//wp-content/uploads/2011/01/gorch-fock5.jpg
 Gorch Fock

 http://www.rs-modellversand.de/WebRoot/Store3/Shops/62532101/4BCD/FF01/2F2F/8FF0/843C/C0A8/2935/BA09/80865.JPG
 Santa Maria

 http://www.dpsvip.com/images/news/black%20pearl%20ship.JPG
 Piratenschiff

 Motorboote:
 -----------
 
 http://www.bootszubehoer-markt.de/shop/contents/media/t_suzumar-10-ds-3.jpg
 Schlauchmotorboot

 http://www.salzi.at/wp-content/uploads/2013/07/polizeiboot_d_20487.jpg
 Polizeiboot

 http://www.hamburg-heide-harz.de/images/20070608sportboot.jpg
 Speedboot

 http://www.hamburg-heide-harz.de/images/20090924eclipse.jpg
 Luxusyacht
 
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace Gebrauchtbootsverkauf
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent                  (); // vorgegebene Initialisierung...

            // d. einzelnen Boottypen anlegen

            TreeViewItem RudBt = new TreeViewItem(); // Obj. reservieren
            RudBt.Header       =       "Ruderboote"; // Treeview-Unterüberschrfit setzen
            root.Items.Add                  (RudBt); // anlegen           

            TreeViewItem SegBt = new TreeViewItem(); // Obj. reservieren
            SegBt.Header       =       "Segelboote"; // Treeview-Unterüberschrfit setzen
            root.Items.Add                  (SegBt); // anlegen           

            TreeViewItem MotBt = new TreeViewItem(); // Obj. reservieren
            MotBt.Header       =       "Motorboote"; // Treeview-Unterüberschrfit setzen
            root.Items.Add                  (MotBt); // anlegen           
        }

        private void OnSelectedItemChanged(object sender, RoutedPropertyChangedEventArgs<object> e)
        {
            
            string   wd_title =""            ; // der Festertitel...
            Object[] AR_boats = new Boot[] {}; // hier werden später die Boote reingepackt...

            TreeViewItem selectedItem = (TreeViewItem)e.NewValue;  // ausgewähltes Element auslesen

            if (selectedItem.Name != "root") // prüfen, ob schon eine Kategorie ausgewählt wurde, d.h. nicht noch das Wurzelelement vorliegt
               {

                // Boote und Bilddefinitionen anlegen, wenn etwas gewählt wurde

                Ruderboot RudBt1 = new Ruderboot() { Modell = "Einbaum"          , Sitze =   4, Preis =        15.50, Bilddatei = "einbaum.jpg"                            };
                Ruderboot RudBt2 = new Ruderboot() { Modell = "Sportboot"        , Sitze =   6, Preis =      3220.10, Bilddatei = "sportboot.jpg"                          };
                Ruderboot RudBt3 = new Ruderboot() { Modell = "Touristenboot"    , Sitze =   8, Preis =       999.99, Bilddatei = "touristenboot.jpg"                      };
                Ruderboot RudBt4 = new Ruderboot() { Modell = "Flaschenfloß"     , Sitze =   1, Preis =         20.3, Bilddatei = "flaschenfloss.jpg"                      };

                Segelboot SegBt1 = new Segelboot() { Modell = "Jolle"            , Sitze =   6, Preis =    405680.70, Bilddatei = "segeljolle.jpg"       , Flaeche  =  100 };
                Segelboot SegBt2 = new Segelboot() { Modell = "Gorch Fock"       , Sitze = 220, Preis =   4234567.80, Bilddatei = "gorchfock.jpg"        , Flaeche  =  250 };
                Segelboot SegBt3 = new Segelboot() { Modell = "Santa Maria"      , Sitze = 160, Preis =    380000.60, Bilddatei = "santamaria.jpg"       , Flaeche  =  300 };
                Segelboot SegBt4 = new Segelboot() { Modell = "Piratenschiff"    , Sitze = 180, Preis =    127560.40, Bilddatei = "piratenschiff.jpg"    , Flaeche  =  200 };

                Motorboot MotBt1 = new Motorboot() { Modell = "Schlauchmotorboot", Sitze =   6, Preis =         1322, Bilddatei = "schlauchmotorboot.jpg", Leistung =   12 };
                Motorboot MotBt2 = new Motorboot() { Modell = "Polizeiboot"      , Sitze =   4, Preis =     17100.46, Bilddatei = "polizeiboot.jpg"      , Leistung =   70 };
                Motorboot MotBt3 = new Motorboot() { Modell = "Speedboot"        , Sitze =   7, Preis =        12833, Bilddatei = "speedboot.jpg"        , Leistung =  320 };
                Motorboot MotBt4 = new Motorboot() { Modell = "Luxusyacht"       , Sitze = 160, Preis = 287276123.45, Bilddatei = "luxusyacht.jpg"       , Leistung = 3480 };

                switch (selectedItem.Header.ToString()) // anhand des in String gewandelten Headers die entsprechenden Boote aufbereiten
                     {
                     case "Ruderboote":
                          AR_boats = new Ruderboot[] { RudBt1, RudBt2, RudBt3, RudBt4 };
                          wd_title =  "Ruderboote: Gut für Ihre Gesundheit und Fitness";
                          break                                                        ;
                     case "Segelboote":
                          AR_boats = new Segelboot[] { SegBt1, SegBt2, SegBt3, SegBt4 };
                          wd_title =         "Segelboote: Das Richtige für Abenteurer!";
                          break                                                        ;
                     case "Motorboote":
                          AR_boats = new Motorboot[] { MotBt1, MotBt2, MotBt3, MotBt4 };
                          wd_title =        "Motorboote - Gas geben, steuern - fertig!";
                          break                                                        ;
                     }

                BootsAngebot Angebote = new BootsAngebot(wd_title, AR_boats); // den Angebotsdialog anlegen

                // und darstellen:

                Angebote.Owner =                                                             this;
                Angebote.WindowStartupLocation = System.Windows.WindowStartupLocation.CenterOwner;
                Angebote.ShowDialog                                                            ();
            }
        }
    }
}
