/* -------------------------------------------------------------------------------------------- */
/* bungs-T-SQL-Script #1 Dr. Bll-LV Datenbanken SS2015 / V0.9 (c) mar / 2015 www.Gossmann.at  */
/* designed and developed using SQL-Server Express V2012 and SCRIPT-TO-FUNCTION with a few mods */
/*  																							*/
/* WARNING: NOT TO BE USED IN PRODUCITON ENVIRONMENTS!											*/
/* tested on US-Version of: Windows 8.1 - 32 prof. / SQL-Server Express 2012 SP1			    */
/*																								*/
/* RELEASE NOTES: BITTE PFAD BEI DATEINAMEN ALLENFALLS ANPASSEN - STELLE SUCHEN MIT "xxx"		*/
/*																								*/
/* TRIGGER-SKRIPT BITTE IN SEPARATEM Query-Fenster laufen lassen, um 7er-Beschrnkung zu testen */
/*																								*/
/* -------------------------------------------------------------------------------------------- */

/* --------------------------------------------------------------------------------------------------------- */
/* alles DDL-Bereich ab hier (so ziemlich alles, was mit CREATE, ALTER und DROP zu tun hat, fllt darunter): */
/* Quelle: Garcia Marci Frohock: SQL-Server 2000 - Das Handbuch S. 254 ff.                                   */
/* --------------------------------------------------------------------------------------------------------- */

/* Frage 1) Write the command(s) to create the student database. 																		*/
/* Die "Meisterdatenbank" des SQL-Systems ist zustndig fr das Verwalten und das Anlegen der eigentlichen Nutzdatenbanken -> auswhlen */
/* DDL 											          																				*/

SET NOCOUNT OFF /* kann bei Bedarf ON-gesetzt werden, damit die Anzahl der betroffenen Datenreihen nicht anzegeigt wird */

USE [master]
GO
BEGIN TRY					/* TRY-CATCH-Konstrukt, da beim 1. Aufruf Datenbank sicher nicht existiert und Fehler unterdrckt werden soll */
DROP DATABASE db_students01 /* allfllig bei bereits ausgefhrtem T-SQL-Script alte Datenbank schmeien									  */
END TRY

BEGIN CATCH
PRINT 'FEHLER ABGEFANGEN'
END CATCH

/* bungsdatenbank anlegen lassen, starten und auf SQL-Server V2012er-Kompatibilittslevel hochfahren sowie Schreibzugriffe ermglichen - Anlegen ohne Pfad fr Default-DB-Verzeichnis */

CREATE DATABASE [db_students01]
 CONTAINMENT = NONE
 ON  PRIMARY 
/* xxx BITTE PFAD ALLENFALLS AN LOKALE GEGEBENHEITEN ANPASSEN */
( NAME = N'db_students', FILENAME = N'c:\Program Files\Microsoft SQL Server\MSSQL11.SQLEXPRESS\MSSQL\DATA\db_students01.mdf' , SIZE = 5120KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB )
 LOG ON 
( NAME = N'db_students_log', FILENAME = N'c:\Program Files\Microsoft SQL Server\MSSQL11.SQLEXPRESS\MSSQL\DATA\db_students01_log.ldf' , SIZE = 1024KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)
GO

ALTER DATABASE [db_students01] SET COMPATIBILITY_LEVEL = 110
GO

ALTER DATABASE [db_students01] SET  READ_WRITE 
GO

/* Frage 2) Write the command(s) to add a student with key personal data and seven classes. You determine which items could be declared as null. */
/* Meisterdatenbank erledigt -> eben angelegte Studentendatenbank auswhlen und Tabelle nach obiger Frage zur Aufnahme von Werten anlegen		 */
/* DDL 																																			 */

USE [db_students01]
GO

/* statt "NULL", wenn nichts eingegeben wurde in entsprechend zulssige Felder, 0 (Wert) liefern lassen */
SET ANSI_NULLS ON
GO

/* brav Anfhrungszeichen fr Namen verwenden -> falls mit SQL-Anweisungen identisch sein sollte */
SET QUOTED_IDENTIFIER ON
GO

/* fhrende Leerzeichen von Werten abschneiden lassen */
SET ANSI_PADDING ON
GO

/* zuerst die Schlertabelle anlegen - 70 Zeichen fr Name, Vorname und weitere Namen (knnen leer sein) 																	*/
/* Geschlecht standardm. mit "w" fr weiblich vorbelegen (sollen ihre Freude haben die Mdels und man hat Ruhe vor diversen Frauengruppen, die sich sonst aufregen knnten) */
/* bei mehr Buben, die eingetragen werden, kann man immer noch auf "m" ndern																								*/
/* Primrschlssel wird mit Jahr 2015 und Inkrement 1 vorbelegt 																											*/

CREATE TABLE [dbo].[tbl_students](
	[studentID] [int] IDENTITY(201500001,1) NOT NULL,
	[Nachname] [nvarchar](70) NOT NULL,
	[Vorname] [nvarchar](70) NOT NULL,
	[weitere_Namen] [nvarchar](70) NULL,
	[Geschlecht] [char](1) NOT NULL,
	[Geburtsdatum] [date] NOT NULL,
	[Schuljahr] [int] NOT NULL,                     /* Schuljahr = die eigentliche Klasse */
 CONSTRAINT [PK_tbl_students] PRIMARY KEY CLUSTERED /* gleich als Index nehmen 		      */
(
	[studentID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] /* nicht Key, sondern primre Dateigruppe -> mehrere davon brauchts hier (noch) nicht */

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[tbl_students] ADD  CONSTRAINT [DF_tbl_students_Geschlecht]  DEFAULT ('w') FOR [Geschlecht]
GO

/* jetzt die Klassenbezeichnungstabelle anlegen (gebraucht wird eine eindeutige ID dafr und die einzelnen Bezeichnungen */
/* Beschrnkung auf sieben Wahlmglichkeiten erfolgt spter durch gesonderten Trigger 			                         */

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[tbl_classes](
	[classID] [int] IDENTITY(1,1) NOT NULL,
	[Klassenbezeichnung] [varchar](40) NOT NULL,
 CONSTRAINT [PK_tbl_classes] PRIMARY KEY CLUSTERED /* gleich als Index nehmen */
(
	[classID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

/* Frage 3) Write the command(s) to add one class for an existing student, with a maximum of seven classes. */
/* zuerst DML + dann DDL																					*/

/* DML-Teil der Frage 3:																	    				  */
/* da derzeit weder ein "existig student" noch irgendwelche Klassenbezeichnungen vorhanden sind,				  */
/* mssen diese zuerst einmal eingepfelgt werden, um mit der max. "7-Klassenbezeichnungszuweisung" weiterzumachen */

/* die Personen anlegen */

INSERT [dbo].[tbl_students] ([Nachname], [Vorname], [Geschlecht], [Geburtsdatum], [Schuljahr]) VALUES ('Bundy', 'Al', 'm', '1955-03-12', '3')
INSERT [dbo].[tbl_students] ([Nachname], [Vorname], [Geschlecht], [Geburtsdatum], [Schuljahr]) VALUES ('Knight', 'Michael', 'm', '1988-03-03', '2')
INSERT [dbo].[tbl_students] ([Nachname], [Vorname], [Geschlecht], [Geburtsdatum], [Schuljahr]) VALUES ('Croft', 'Lara', 'w', '1993-07-08', '1')
INSERT [dbo].[tbl_students] ([Nachname], [Vorname], [Geschlecht], [Geburtsdatum], [Schuljahr]) VALUES ('Solo', 'Han', 'm', '1977-12-27', '7')
INSERT [dbo].[tbl_students] ([Nachname], [Vorname], [Geschlecht], [Geburtsdatum], [Schuljahr]) VALUES ('Archer', 'Jonathan', 'm', '1982-03-05', '4')
INSERT [dbo].[tbl_students] ([Nachname], [Vorname], [weitere_Namen], [Geschlecht], [Geburtsdatum], [Schuljahr]) VALUES ('Rambo', 'John', 'James', 'm', '1963-02-21', '7')
INSERT [dbo].[tbl_students] ([Nachname], [Vorname], [Geschlecht], [Geburtsdatum], [Schuljahr]) VALUES ('Sackbauer', 'Antonia', 'w', '1974-06-08', '5')
INSERT [dbo].[tbl_students] ([Nachname], [Vorname], [Geschlecht], [Geburtsdatum], [Schuljahr]) VALUES ('Lowinski', 'Daniela', 'w', '1951-04-05', '5')
INSERT [dbo].[tbl_students] ([Nachname], [Vorname], [Geschlecht], [Geburtsdatum], [Schuljahr]) VALUES ('Bond', 'James', 'm', '1962-11-17', '6')
INSERT [dbo].[tbl_students] ([Nachname], [Vorname], [Geschlecht], [Geburtsdatum], [Schuljahr]) VALUES ('Sisko', 'Benjamin', 'm', '1956-02-21', '8')
INSERT [dbo].[tbl_students] ([Nachname], [Vorname], [weitere_Namen], [Geschlecht], [Geburtsdatum], [Schuljahr]) VALUES ('Kirk', 'James', 'Tiberius', 'm', '1966-04-07', '4')
INSERT [dbo].[tbl_students] ([Nachname], [Vorname], [Geschlecht], [Geburtsdatum], [Schuljahr]) VALUES ('Janeway', 'Kathryn', 'w', '1972-08-12', '3')
INSERT [dbo].[tbl_students] ([Nachname], [Vorname], [Geschlecht], [Geburtsdatum], [Schuljahr]) VALUES ('Darko', 'Donnie', 'm', '1989-02-17', '1')
INSERT [dbo].[tbl_students] ([Nachname], [Vorname], [Geschlecht], [Geburtsdatum], [Schuljahr]) VALUES ('Picard', 'Jean-Luc', 'm', '1987-09-01', '2')

/* die Fcher anlegen (=Klassenbezeichnung US: "class" = AT: "Kurs") und NICHT "klassische Klasse" im Sinne von Klassenzimmer */

INSERT [dbo].[tbl_classes] ([Klassenbezeichnung]) VALUES ('Biologie und Umweltkunde')
INSERT [dbo].[tbl_classes] ([Klassenbezeichnung]) VALUES ('Chemie')
INSERT [dbo].[tbl_classes] ([Klassenbezeichnung]) VALUES ('Russisch')
INSERT [dbo].[tbl_classes] ([Klassenbezeichnung]) VALUES ('Englisch')
INSERT [dbo].[tbl_classes] ([Klassenbezeichnung]) VALUES ('Spanisch')
INSERT [dbo].[tbl_classes] ([Klassenbezeichnung]) VALUES ('Deutsch')
INSERT [dbo].[tbl_classes] ([Klassenbezeichnung]) VALUES ('Latein')
INSERT [dbo].[tbl_classes] ([Klassenbezeichnung]) VALUES ('Musik')
INSERT [dbo].[tbl_classes] ([Klassenbezeichnung]) VALUES ('Bildnerische Erziehung')
INSERT [dbo].[tbl_classes] ([Klassenbezeichnung]) VALUES ('Religion')
INSERT [dbo].[tbl_classes] ([Klassenbezeichnung]) VALUES ('Geschichte')
INSERT [dbo].[tbl_classes] ([Klassenbezeichnung]) VALUES ('Leibesbungen')
INSERT [dbo].[tbl_classes] ([Klassenbezeichnung]) VALUES ('Mathematik')
INSERT [dbo].[tbl_classes] ([Klassenbezeichnung]) VALUES ('Physik')
INSERT [dbo].[tbl_classes] ([Klassenbezeichnung]) VALUES ('Psychologie')
INSERT [dbo].[tbl_classes] ([Klassenbezeichnung]) VALUES ('Geographie und Wirtschaftskunde')

/* DDL-Teil der Frage 3:																																		     */
/* Zuordnungstabelle fr die Belegungen der Fcher anlegen mit aktualisierungs und Lschweitergabe, wenn was aus PRIMARY-Key-Tabellen gendert / verschwinden sollte */

CREATE TABLE [dbo].[tbl_std_in_class](
	[studentID] [int] FOREIGN KEY REFERENCES [dbo].[tbl_students](studentID)
	ON DELETE CASCADE
	ON UPDATE CASCADE,
	[classID] [int] FOREIGN KEY REFERENCES [dbo].[tbl_classes](classID)
	ON DELETE CASCADE
	ON UPDATE CASCADE
) ON [PRIMARY]

/* DML-Teil wieder...    */
/* Werte darin eintragen */

INSERT [dbo].[tbl_std_in_class] ([studentID], [classID]) VALUES ('201500001','10')
INSERT [dbo].[tbl_std_in_class] ([studentID], [classID]) VALUES ('201500001','2')
INSERT [dbo].[tbl_std_in_class] ([studentID], [classID]) VALUES ('201500001','5')
INSERT [dbo].[tbl_std_in_class] ([studentID], [classID]) VALUES ('201500001','7')
INSERT [dbo].[tbl_std_in_class] ([studentID], [classID]) VALUES ('201500001','6')
INSERT [dbo].[tbl_std_in_class] ([studentID], [classID]) VALUES ('201500001','9')
INSERT [dbo].[tbl_std_in_class] ([studentID], [classID]) VALUES ('201500001','3')

INSERT [dbo].[tbl_std_in_class] ([studentID], [classID]) VALUES ('201500014','3')
INSERT [dbo].[tbl_std_in_class] ([studentID], [classID]) VALUES ('201500014','4')
INSERT [dbo].[tbl_std_in_class] ([studentID], [classID]) VALUES ('201500014','12')
INSERT [dbo].[tbl_std_in_class] ([studentID], [classID]) VALUES ('201500011','7')
INSERT [dbo].[tbl_std_in_class] ([studentID], [classID]) VALUES ('201500011','9')
INSERT [dbo].[tbl_std_in_class] ([studentID], [classID]) VALUES ('201500011','1')
INSERT [dbo].[tbl_std_in_class] ([studentID], [classID]) VALUES ('201500011','2')


/* an dieser Stelle msste der Trigger eingebunden werden, lsst SQL nicht zu, darum ist er in einer zweiten Datei */
/* gehrt auch separat ausgefhrt und demonstriert dann die Beschrnkung auf obige sieben Zuordnungen			   */

/* Frage 4) Write the command(s) to update one data element in this database.														     */
/* passt - gleich zur Demonstration anhand von Hr. Picard den nicht atomaren Vornamen aufteilen in Vorname und eben einen weiteren Namen */
/* damits wirkt zum Beweis auch ein "DAVOR und DANACH-Select" zur Ausgabe...															 */
/* DML																																	 */

SELECT * FROM [dbo].[tbl_students] WHERE ([Nachname] = 'Picard' AND [Geburtsdatum] = '1987-09-01')
UPDATE [dbo].[tbl_students] SET [Vorname]='Jean', [weitere_Namen]='Luc' WHERE ([Nachname] = 'Picard' AND [Geburtsdatum] = '1987-09-01')
SELECT * FROM [dbo].[tbl_students] WHERE ([Nachname] = 'Picard' AND [Geburtsdatum] = '1987-09-01')

/* Frage 5.) Write the command(s) that lists the data for a student with a given ID. */
/* warum nur 1? fr was die ganze DB generieren ansonsten? also 3 gleich...		     */
/* dank VIEW-Erstellungsmglichkeit sind die Abfragen dazu eh ein Kinderspiel...     */
/* nur die gewnschte ID der jeweiligen Person musste hinten eingefgt werden		 */
/* DML																				 */

SELECT          dbo.tbl_students.Nachname, dbo.tbl_students.Vorname, dbo.tbl_students.weitere_Namen, dbo.tbl_students.Geschlecht, dbo.tbl_students.Geburtsdatum, dbo.tbl_students.Schuljahr, 
                         dbo.tbl_classes.Klassenbezeichnung AS Classes_im_Sinne_Fach
FROM            dbo.tbl_students INNER JOIN
                         dbo.tbl_std_in_class ON dbo.tbl_students.studentID = dbo.tbl_std_in_class.studentID INNER JOIN
                         dbo.tbl_classes ON dbo.tbl_std_in_class.classID = dbo.tbl_classes.classID where dbo.tbl_students.studentID='201500001'

SELECT          dbo.tbl_students.Nachname, dbo.tbl_students.Vorname, dbo.tbl_students.weitere_Namen, dbo.tbl_students.Geschlecht, dbo.tbl_students.Geburtsdatum, dbo.tbl_students.Schuljahr, 
                         dbo.tbl_classes.Klassenbezeichnung AS Classes_im_Sinne_Fach
FROM            dbo.tbl_students INNER JOIN
                         dbo.tbl_std_in_class ON dbo.tbl_students.studentID = dbo.tbl_std_in_class.studentID INNER JOIN
                         dbo.tbl_classes ON dbo.tbl_std_in_class.classID = dbo.tbl_classes.classID where dbo.tbl_students.studentID='201500014'

SELECT          dbo.tbl_students.Nachname, dbo.tbl_students.Vorname, dbo.tbl_students.weitere_Namen, dbo.tbl_students.Geschlecht, dbo.tbl_students.Geburtsdatum, dbo.tbl_students.Schuljahr, 
                         dbo.tbl_classes.Klassenbezeichnung AS Classes_im_Sinne_Fach
FROM            dbo.tbl_students INNER JOIN
                         dbo.tbl_std_in_class ON dbo.tbl_students.studentID = dbo.tbl_std_in_class.studentID INNER JOIN
                         dbo.tbl_classes ON dbo.tbl_std_in_class.classID = dbo.tbl_classes.classID where dbo.tbl_students.studentID='201500011'

/* Frage 6.) Label each command from questions 15 as either DML or DDL. */
/* = bereits oben in den Kommentaren erfolgt						     */

